/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio;

import com.jme3.audio.Filter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.util.NativeObject;
import java.io.IOException;

public class LowPassFilter
extends Filter {
    protected float volume;
    protected float highFreqVolume;

    public LowPassFilter(float volume, float highFreqVolume) {
        this.setVolume(volume);
        this.setHighFreqVolume(highFreqVolume);
    }

    protected LowPassFilter(int id) {
        super(id);
    }

    public float getHighFreqVolume() {
        return this.highFreqVolume;
    }

    public void setHighFreqVolume(float highFreqVolume) {
        if (highFreqVolume < 0.0f || highFreqVolume > 1.0f) {
            throw new IllegalArgumentException("High freq volume must be between 0 and 1");
        }
        this.highFreqVolume = highFreqVolume;
        this.updateNeeded = true;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        if (volume < 0.0f || volume > 1.0f) {
            throw new IllegalArgumentException("Volume must be between 0 and 1");
        }
        this.volume = volume;
        this.updateNeeded = true;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.volume, "volume", 0.0f);
        oc.write(this.highFreqVolume, "hf_volume", 0.0f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.volume = ic.readFloat("volume", 0.0f);
        this.highFreqVolume = ic.readFloat("hf_volume", 0.0f);
    }

    public NativeObject createDestructableClone() {
        return new LowPassFilter(this.id);
    }
}

